//
//  GADTopOnExtras.h
//  AdmobTopOnAdapter
//
//  Created by GUO PENG on 2024/4/22.
//  Copyright © 2024 Google, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, GADTopOnErrorCode) {
    
    // Invalid parameters encountered(App ID、App Key orPlacement ID being nil)
    GADTopOnErrorInvalidServerParameters = 1014,
    // Ad source not filled, cause by customize fillter.
    GADTopOnErrorAdNoFill = 1030,
};

@interface GADTopOnExtras : NSObject

/// native
@property (nonatomic, assign) CGSize adSize;

/// native ad
@property (nonatomic, assign) BOOL isAdSizeToFit;


@end

NS_ASSUME_NONNULL_END
